@echo off
setlocal enabledelayedexpansion

echo Step 1: Starting script...

:: Check if a file was dragged and dropped
if "%~1"=="" (
    echo Error: Please drag and drop an MP4 file onto this script.
    echo Usage: Drag a .mp4 file onto this script to convert it to non-transparent H.264 MP4.
    pause
    exit /b 1
)

echo Step 2: File check passed...

:: Set input and output paths
set "input=%~1"
set "output=%~dp0converted_%~n1.mp4"

echo Step 3: Input set to "%input%"
echo Step 4: Output set to "%output%"

:: Check if the input file exists
if not exist "%input%" (
    echo Error: Input file "%input%" not found.
    pause
    exit /b 1
)

echo Step 5: Input file exists...

:: Use FFmpeg from the same folder as the script
set "ffmpeg=%~dp0ffmpeg.exe"

echo Step 6: FFmpeg path set to "%ffmpeg%"

:: Check if FFmpeg exists
if not exist "%ffmpeg%" (
    echo Error: ffmpeg.exe not found in the same folder as this script.
    echo Please place ffmpeg.exe in "%~dp0".
    pause
    exit /b 1
)

echo Step 7: FFmpeg exists...

:: Test FFmpeg
echo Step 8: Testing FFmpeg...
"%ffmpeg%" -version
if !errorlevel! neq 0 (
    echo Error: FFmpeg failed to run.
    pause
    exit /b 1
)

echo Step 9: FFmpeg test successful...

:: Convert to H.264 MP4, removing transparency
echo Step 10: Converting "%input%" to non-transparent H.264 MP4...
"%ffmpeg%" -i "%input%" -c:v libx264 -profile:v baseline -level 3.0 -pix_fmt yuv420p -b:v 5M -c:a aac -b:a 192k "%output%"
if !errorlevel! equ 0 (
    echo Step 11: Successfully converted "%input%" to "%output%"
) else (
    echo Step 12: Error: Failed to convert "%input%".
)

echo Step 13: Script completed.
pause